<?php
header('Content-Type: application/json');

// Incluir la conexión a la base de datos
include 'conn.php';

// Verificar la conexión
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit();
}

// Realizar la consulta a la base de datos para obtener los datos de cuentas por pagar

$query = "SELECT p.empresa, SUM(r.total) AS total_pagar
          FROM proveedores p
          JOIN reservas r ON p.empresa = r.agencia
          WHERE r.pay_method = 'Payment Pending'
          GROUP BY p.empresa
          ORDER BY total_pagar DESC";

          
$result = $conn->query($query);

// Verificar si la consulta tuvo éxito
if (!$result) {
    http_response_code(500);
    echo json_encode(['error' => 'Query failed: ' . $conn->error]);
    exit();
}

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Convertir los datos a JSON y devolverlos
echo json_encode($data);
?>

