<?php

// Conexión a la base de datos
include 'conn.php';

// Obtener los datos enviados por POST
$idrProveedor = $_POST['idr_proveedor'];
$selectProveedor = $_POST['select_proveedor'];

// Preparar y ejecutar la consulta de actualización
$sql = "UPDATE reservas SET proveedor_id = ? WHERE idr = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ss", $selectProveedor, $idrProveedor);
    if ($stmt->execute()) {
        echo json_encode(['status' => 'ok', 'message' => 'Proveedor actualizado correctamente']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Error al actualizar el proveedor: ' . $stmt->error]);
    }
    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error en la preparación de la consulta: ' . $conn->error]);
}

// Cerrar la conexión
$conn->close();
?>