<?php 
session_start();
setlocale( LC_TIME, 'es_MX.UTF-8', 'esp' );
date_default_timezone_set('America/Mazatlan');

include 'func/conn.php';

$sessData = !empty( $_SESSION[ 'sessData' ] ) ? $_SESSION[ 'sessData' ] : '';
if ( !empty( $sessData[ 'status' ][ 'msg' ] ) ) {
  $statusMsg = $sessData[ 'status' ][ 'msg' ];
  $statusMsgType = $sessData[ 'status' ][ 'type' ];
  unset( $_SESSION[ 'sessData' ][ 'status' ] );
}

if ( isset( $_SESSION[ 'sessData' ] ) && $_SESSION[ 'sessData' ] == true ) {} else {

  echo '<script type="text/javascript">window.location.href="login.php";
    </script>';
  exit;
}

if ( !empty( $sessData[ 'userLoggedIn' ] ) && !empty( $sessData[ 'userID' ] ) ) {
  include 'func/user.php';
  $user = new User();
  $conditions[ 'where' ] = array(
    'id' => $sessData[ 'userID' ],
  );
  $conditions[ 'return_type' ] = 'single';
  $userData = $user->getRows( $conditions );
  $userName = $userData[ 'first_name' ];
  $user_lastname = $userData[ 'last_name' ];
  $email = $userData[ 'email' ];
  $ida = $userData[ 'ida' ];
  $avatar = $userData[ 'avatar' ];
  $rol = $userData[ 'rol' ];
}



$sql = "SELECT * FROM generales WHERE ida = '$ida'";
$result = $conn->query( $sql );

if ( $result->num_rows > 0 ) {
  // output data of each row
  while ( $row = $result->fetch_assoc() ) {

    $empresa = $row[ "empresa" ];
    $logo = $row[ "logo" ];
    $empresa_telefono = $row[ "telefono" ];
    $empresa_email = $row[ "email" ];

  }

}

function GeraHash( $qtd ) {

  $Caracteres = '0123456789';
  $QuantidadeCaracteres = strlen( $Caracteres );
  $QuantidadeCaracteres--;

  $Hash = NULL;
  for ( $x = 1; $x <= $qtd; $x++ ) {
    $Posicao = rand( 0, $QuantidadeCaracteres );
    $Hash .= substr( $Caracteres, $Posicao, 1 );
  }

  return $Hash;
}

$idr = GeraHash( 8 );

$titulo = "Reservas";
?>
<!DOCTYPE html>

<html
  lang="en"
  class="light-style layout-navbar-fixed layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title><?php echo $titulo ?></title>

    

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />

    <!-- Icons -->
    <link rel="stylesheet" href="assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/sweetalert2/sweetalert2.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker3.min.css" integrity="sha512-rxThY3LYIfYsVCWPCW9dB0k+e3RZB39f23ylUYTEuZMDrN/vRqLdaCBo/FbvVT6uC2r0ObfPzotsfKF9Qc5W5g==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="assets/vendor/js/template-customizer.js"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>

  </head>

  <body>
    <input type="hidden" id="ida" value="<?php echo $ida; ?>">
    <input type="hidden" id="idrAsingado" value="<?php echo $idr; ?>">
    <input type="hidden" id="idr" value="">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('layout/menu.php'); ?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('layout/navbar.php'); ?>
          <!-- / Navbar -->
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
            
            
            <div class="row">
              <!-- SERVICIO ACTUAL -->
              <div class="col-lg-4 col-md-4 col-12 mb-4">
                <div class="card h-100">
                  <div class="card-header">
                  <div class="d-block text-nowrap text-end mb-2">Hora actual: <span class="text-success" id="hora"></span></div>
                    <h3 class="card-title mb-2">Próximo Servicio</h3>
                    <h5><span id="serviceText">--</span></h5>
                    <p>Estado: <span class="d-block text-nowrap pulse" id="serviceStatus">--</span>
                    
                    </p>
                    <p id="paytext">Pago: <span class="d-block mb-4 text-nowrap" id="servicePay">--</span>
                    <div class="spinner-border" role="status">
                      <span class="visually-hidden">Loading...</span>
                    </div>
                   </p>
                    
                    <button id="pagado" class="btn btn-sm btn-success mb-4">--</button>
                    <div id="serviceObsInt" class="alert alert-warning" role="alert">
                      <strong>Observaciones Internas:</strong> <span id="serviceObsIntText">--</span>
                    </div>
                    <!--agregamos la hora actual justificado a la derecha del header-->
                    

                  </div>
                  <div class="card-body">
                    <div class="row align-items-end">
                      <div class="col-6">
                        <h4 class="text-primary" id="serviceTime">--:--</h4>
                        <h5 class="text-muted mb-2" id="aerolinea"></h5>
                        <small class="d-block mb-1" id="serviceDetails">Detalle del servicio: Pasajero --, Destino: --</small>
                        <div class="mt-0 mb-4" id="icons">
                        <i id="shoppingIcon" class="fa-solid fa-cart-shopping" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="right" title="Requiere Shopping Stop"></i>
                        <i id="babyseatIcon" class="fa-solid fa-baby-carriage" style="color: #efa0e2" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="right" data-bs-custom-class="tooltip-info"></i>
                        <i id="carseatIcon" class="fa-solid fa-baby-carriage text-primary" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="right" data-bs-custom-class="tooltip-primary"></i>
                        <i id="boosterseatIcon" class="fa-solid fa-baby-carriage text-warning" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="right" data-bs-custom-class="tooltip-warning"></i>
                       
                        </div>
                        <div id="agency" class="mt-4 mb-4"></div>
                        
                        <div id="proveedorText" class="mt-4 mb-4"></div>
                      </div>
                      <div class="col-6">
                        <h5 id="car" class="text-muted mb-2">Vehículo</h5>
                        <img id="carImg" src="" width="140" class="rounded-start" alt="Vehicle">
                      </div>
                    </div>
                  </div>
                  <div class="card-footer">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="d-flex align-items-center">
                      
                        <button id="serviceStartBtn" class="btn btn-sm btn-success">Completar</button>
                        <a id="generar_pdf_actual" class="btn btn-sm btn-warning ms-2 text-white">PDF</a>
                        <button id="nameSing" class="btn btn-sm btn-info ms-2">Imprimir Sing</button>
                        <button id="verDetallesBtn" data-bs-toggle="modal" data-bs-target="#editar_reserva" class="btn btn-sm btn-primary editar-reserva ms-2">Ver</button>
                      </div>
                    </div>
                  </div>

                </div>
              </div>

              <!--/ SERVICIO ACTUAL -->

              <!-- SERVICIOS DIARIOS -->
              <div class="col-lg-8 col-md-8 col-12 mb-4">
                <div class="card">
                  <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">Servicios</h5>
                    <div class="dropdown">
                      <button class="btn p-0" type="button" id="marketingOptions" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="bx bx-dots-vertical-rounded"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-end" aria-labelledby="marketingOptions">
                        <a class="dropdown-item" href="javascript:void(0);">Refresh</a>
                      </div>
                    </div>
                  </div>
                  <div class="table-responsive p-4">
                    <table class="table border-top" id="reservas_table_diarios">
                      <thead>
                        <tr>
                          <th></th>
                          <th>Nombre</th>
                          <th>Hotel</th>
                          <th>Aerolinea</th>
                          <th>Hora</th>
                          <th>Status</th>
                          <th>Proveedor</th>
                          <th>Chofer</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody class="table-border-bottom-0">

                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <!--/ Marketing Campaigns -->
            </div>
        </div>
            <!-- / Content -->


            <!-- Footer -->
            <?php include('layout/footer.php'); ?>
            <div class="content-backdrop fade"></div>
          </div>

          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->
    <!--Modal agregar chofer-->
<div class="modal fade" id="add_chofer" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Agregar Chofer A Servicio</h3>
        </div>
        <form  class="row g-3" method="post">
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Lista de choferes</label>
            <select name="chofer" class="form-control" id="id_chofer">
              <option value="">Sin Chofer</option>
              <?php
              $sql = "SELECT * FROM choferes WHERE status <> 4 ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'nombre' ] . '" data-nombre='. $row[ 'nombre' ] . '" >' . $row[ 'nombre' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          
          <div class="col-12 text-center mt-4">
          <input type="hidden" id="idr-chofer" value="">
            <button type="button" id="asignar_chofer" class="btn btn-primary me-1 me-sm-3" >Asignar Chofer</button>
            <button type="reset" class="btn btn-label-secondary me-1 me-sm-3" data-bs-dismiss="modal" aria-label="Close" >Cerrar </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="add_proveedor" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Asignar Agencias</h3>
        </div>
        <form  class="row g-3" method="post">
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Lista de Agencias</label>
            <select name="proveedor" class="form-control" id="proveedor">
              
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND (tipo_agencia = 'Agencias' OR tipo_agencia = 'Ambas')";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'empresa' ] . '" data-nombre='. $row[ 'empresa' ] . '" >' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          
          <div class="col-12 text-center mt-4">
          <input type="hidden" id="idr-proveedor" value="">
            <button type="button" id="asignar_proveedor" class="btn btn-primary me-1 me-sm-3" >Asignar Agencias</button>
            <button type="reset" class="btn btn-label-secondary me-1 me-sm-3" data-bs-dismiss="modal" aria-label="Close" >Cerrar </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="actualizar_proveedor" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Asignar Proveedor</h3>
        </div>
        <form  class="row g-3" method="post">
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Lista de Proveedor</label>
            <select name="actualizarProveedorSelect" class="form-control" id="actualizarProveedorSelect">
              
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND (tipo_agencia = 'Agencias Proveedoras' OR tipo_agencia = 'Ambas')";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'id' ] . '" data-nombre='. $row[ 'empresa' ] . '" >' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          
          <div class="col-12 text-center mt-4">
          <input type="hidden" id="actualizar-idr-proveedor" value="">
            <button type="button" id="btn_actualizar_proveedor" class="btn btn-primary me-1 me-sm-3" >Asignar Proveedor</button>
            <button type="reset" class="btn btn-label-secondary me-1 me-sm-3" data-bs-dismiss="modal" aria-label="Close" >Cerrar </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
    <div class="modal fade" id="modalObservaciones" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-sm modal-simple">
        <div class="modal-content p-3 p-md-5">
          <div class="modal-body">
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               <h3>Instrucción de Cobro</h3>
            </div>
             <form  class="row g-3" method="post">
              <div class="col-12 col-md-12">
                <textarea class="form-control" id="observaciones" name="observaciones" rows="3"></textarea>
              </div>
              <div class="col-12 text-center mt-4">
                
                <button type="button" id="actualizar_cobro" class="btn btn-primary me-1 me-sm-3 mb-3" >Agregar instrucción de cobro</button>
                <button type="reset" class="btn btn-label-secondary me-1 me-sm-3" data-bs-dismiss="modal" aria-label="Close" >Cerrar </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="edit_status_modal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-sm modal-simple">
        <div class="modal-content p-3 p-md-5">
          <div class="modal-body">
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               <h3>Editar Status</h3>
            </div>
             <form  class="row g-3" method="post">
              <div class="col-12 col-md-12">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                  <option value="Confirmed">Confirmed</option>
                  <option value="Cancelled">Cancelled</option>
                  <option value="No Show">No Show</option>
                  <option value="Pending">Pending</option>
                </select>
              </div>
              <div class="col-12 text-center mt-4">

                <button type="button" id="actualizar_status" class="btn btn-primary me-1 me-sm-3 mb-3" >Actualizar Status</button>
                <button type="reset" class="btn btn-label-secondary me-1 me-sm-3" data-bs-dismiss="modal" aria-label="Close" >Cerrar </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
<div class="modal fade" id="editar_reserva" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Editar Reserva</h3>
        </div>
        <form  class="row g-3" method="post" action="#">
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Agencia: <span id="prov" class="text-success"></span></label>
            <select name="edit-agencia" class="form-control" id="edit-agencia">
            <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias' ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'empresa' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
              </select>
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Folio Interno</label>
            <input type="text" id="edit-folio" name="folio" class="form-control" />
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Nombre</label>
            <input
            type="text"
            id="edit-name"
            name="name"
            class="form-control" required
            value=""
            />
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label" for="email">email</label>
            <input
            type="text"
            id="edit-email"
            name="email"
            class="form-control" required
            value=""
            />
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label" for="phone">Telefono</label>
            <input
                type="tel"
                            id="edit-phone"
                            name="phone"
                            class="form-control" required
                            value=""
                           
                          />
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="pax">Pax</label>
                          <input type="number" id="edit-pax" name="pax" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="car">Vehiculo</label>
                          <select name="car" class="form-control car-options" id="edit-car">
                          <option value="Sin Vehiculo">Sin Vehiculo</option>
              <?php
              $sql = "SELECT * FROM cars WHERE status <> 4 ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'car' ] . '" >' . $row[ 'car' ] . '</option>';
                }
              }
              ?>
                          </select>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="balance">Pago Recibido</label>
                          <input
                            type="text"
                            id="edit-pagado"
                            name="balance"
                            class="form-control"
                            value="" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" required	 
                          />
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label">Total</label>
                          <input
                            type="text"
                            id="edit-total"
                            name="total"
                            class="form-control"
                            value="" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" required	 
                          />
                        </div>
                        <div class="row" id="llegadas">
                        <div class="mt-5"><h5>Informacion de <span id="txt-servicio">Llegada</span></h5></div>
                        <div class="col-12 col-md-12">
                          <label class="form-label" for="hotel_llegada" id="txt-hotel1">Hotel de Llegada</label>
                          <input type="text" id="edit-hotel-llegada"  name="arrival_hotel" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-12" id="dropoff-tra">
                          <label class="form-label"  id="txt-hotel2">Lugar de Dropoff</label>
                          <input type="text" id="edit-hotel-pickup"  name="" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="fecha_llegada">Fecha de Llegada</label>
                          <input
                            type="text" id="edit-fecha-llegada" name="arrival_date" class="form-control datepicker" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="hora_llegada">Hora de Llegada</label>
                          <input type="text" id="edit-hora-llegada" name="arrival_time" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6 hide-tra">
                          <label class="form-label" for="aerolinea_llegada">Aerolinea Llegada</label>
                          <input
                            type="text"
                            id="edit-aerolinea-llegada"
                            name="arrival_airline"
                            class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6 hide-tra">
                          <label class="form-label" for="vuelo_llegada">Vuelo Llegada</label>
                          <input
                            type="text"
                            id="edit-vuelo-llegada"
                            name="arrival_flight"
                            class="form-control" required value=""/>
                        </div>
                      </div>
                        <div class="row" id="salidas">
                          <div class="mt-5"><h5>Informacion de Salida</h5></div>
                          <div class="col-12 col-md-12">
                            <label class="form-label" for="edit-hotel-salida">Hotel de Salida</label>
                            <input
                            type="text"
                            id="edit-hotel-salida"
                            name="departure_hotel"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-fecha-salida">Fecha de Salida</label>
                          <input
                            type="text"
                            id="edit-fecha-salida"
                            name="departure_date"
                            class="form-control datepicker" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-hora-salida">Hora de Salida</label>
                          <input
                            type="text"
                            id="edit-hora-salida"
                            name="edit-hora-salida"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-pickup-time">Pickup time</label>
                          <input
                            type="text"
                            id="edit-pickup-time"
                            name="edit-pickup-time"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-6">
                          <label class="form-label" for="aerolinea_salida">Aerolinea Salida</label>
                          <input
                            type="text"
                            id="edit-aerolinea-salida"
                            name="departure_airline"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-6">
                          <label class="form-label" for="vuelo_salida">Vuelo Salida</label>
                          <input
                            type="text"
                            id="edit-vuelo-salida"
                            name="departure_flight"
                            class="form-control" required
                            value=""/>
                            <input
                            type="hidden"
                            required
                            value=""/>
                            <input
                            type="hidden"
                            name="update_service"
                            required
                            value=""/>
                          </div>
                          
                        </div>
							

                        <div class="mt-5"><h5>Proveedor</h5></div>
                          <div class="col-md-6 mt-3">
            <label class="form-label" for="edit-agencia-proveedor">Proveedor</label>
            <select name="edit-agencia-proveedor" class="form-control" id="edit-agencia-proveedor">
             
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias Proveedoras' ORDER BY id ASC";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'id' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          <div class="col-md-6 mt-3">
            <label class="form-label" for="edit-costo-proveedor">Costo Proveedor</label>
            <input
                            type="text"
                            id="edit-costo-proveedor"
                            name="editar-costo-proveedor"
                            class="form-control"
                            value="0"
                            onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;"

                          />
          </div>
    
						 <div class="row" >
							  <div class="mt-5"><h5>Extras Services</h5></div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Baby Seat</label>
								  <input
                                   type="text"
                                   name="bbs"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;"
                                   id="edit-bbs" 
										 />
								  
							  </div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Car Seat</label>
								  <input
                                   type="text"
                                   name="crs"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="edit-crs"
										 />
								  
							  </div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Booster Seat</label>
								  <input
                                   type="text"
                                   name="bos"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="edit-bos"
										 />
								  
							  </div>
							  <div class="col-6 mt-3">
								  <div class="form-check form-switch">
									  <input class="form-check-input" type="checkbox" id="edit-shopping" name="shopping" value="1">
									  <label class="form-check-label" for="edit-shopping">Shopping-Stop</label>
								  </div>
                            </div>
							<div class="col-6 mt-3">
								  <label for="exampleFormControlTextarea1" class="form-label">Observaciones Internas</label>
                                  <textarea class="form-control" id="edit-obs-int" rows="3" name="obs_int"></textarea>
                            </div>
							
						  </div>
						<div class="col-12 text-center mt-4">
              <input type="hidden" name="update_idr" id="edit-idr" required value=""/>
              <a class="btn btn-label-warning me-1 me-sm-3" target="_blank" href="" id="generar_pdf">Generar PDF</a>
              <button type="button" class="btn btn-label-success actualizar-reserva">Actualizar</button>
              <button
              type="reset"
              class="btn btn-label-secondary me-1 me-sm-3"
              data-bs-dismiss="modal"
              aria-label="Close">Cerrar </button>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>
  </div>
</div>
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="assets/vendor/libs/sweetalert2/sweetalert2.js" ></script>

    <script src="assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js" integrity="sha512-T/tUfKSV1bihCnd+MxKD0Hm1uBBroVYBOYSk1knyvQ9VyZJpc/ALb4P0r6ubwVPSGB2GvjeoMAJJImBG12TiaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://kit.fontawesome.com/651e797dfa.js" crossorigin="anonymous"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/gsap.min.js"></script>

    <!-- Funciones -->
    <script src="func/js/add_chofer.js"></script> 
    <script src="func/js/getProveedores.js"></script> 



<script>
function animateElement(element) {
  gsap.fromTo(element, 
    { scale: 1, opacity: 0 },  // Estado inicial
    { scale: 1, opacity: 1, duration: 1, repeat: 5 }  // Estado final con efecto de fade in y out
  );
}
        $(document).ready(function () {

          $('.datepicker').datepicker({
            format: 'yyyy-mm-dd'
          });
          
            function actualizarHora() {
                $.ajax({
                    url: 'func/hora_actual.php', // URL al archivo PHP
                    type: 'GET',
                    dataType: 'json',
                    success: function (data) {
                        $('#hora').text(data.hora);
                    },
                    error: function (error) {
                        console.error('Error al obtener la hora:', error);
                    }
                });
            }

            // Actualizar inmediatamente al cargar la página
            actualizarHora();

            // Actualizar cada minuto (60000 milisegundos)
            setInterval(actualizarHora, 60000);
        });
</script>
<script src="func/js/get_servicios.js"></script>
<script src="func/js/widget-servicio-actual.js"></script>
<script>
  //escondemos el spinner de pago
  $('.spinner-border').hide();
  
  //mostrar modal de observaciones cuando se haga click en el boton con el id modalObs
  $(document).on('click', '#modalObs', function () {
    //obtenemos el id del servicio
    var idr = $(this).data('idr');
    $('#modalObservaciones').modal('show');
    $('#idr').val(idr);
    console.log(idr);
  });

  //actualizar instrucción de cobro
  $(document).on('click', '#actualizar_cobro', function () {
    var idr = $('#idr').val();
    var observaciones = $('#observaciones').val();
    $.ajax({
      url: 'func/actualizar_cobro.php',
      type: 'POST',
      data: {
        idr: idr,
        observaciones: observaciones
      },
      success: function (data) {
        console.log(data);
        fetchNextService();
        $('#modalObservaciones').modal('hide');
      }
    });
  });

  //marcar como completado
  $(document).on('click', '#serviceStartBtn', function () {
    var idr = $('#idr').val();
    var pulse = $('.pulse');
    console.log(idr);
    $.ajax({
      url: 'func/completar_servicio.php',
      type: 'POST',
      data: {
        idr: idr
      },
      success: function (data) {
        console.log(data);
        fetchNextService();
        animateElement(pulse);
      }
    });
  });

  // editat status
  $(document).on('click', '#edit_status', function () {
    var idr = $('#idr').val();
    $('#edit_status_modal').modal('show');
    console.log(idr);

  });

  $(document).on('click', '#actualizar_status', function () {
    var idr = $('#idr').val();
    var status = $('#status').val();
    console.log(idr);
    console.log(status);
    $.ajax({
      url: 'func/editar_estatus.php',
      type: 'POST',
      data: {
        idr: idr,
        status: status
      },
      success: function (data) {
        console.log(data);
        fetchNextService();
        $('#edit_status_modal').modal('hide');
      }
    });
  });

  //marcar como pagado o como pendiente
  $(document).on('click', '#pagado', function () {
    var idr = $('#idr').val();
    var pagado = $(this).val();
    var spinner = $('.spinner-border');
    console.log(idr);
    console.log(pagado);
    //escondemos el id servicePay
    $('#paytext').hide();
    spinner.show();
    $.ajax({
      url: 'func/pagado.php',
      type: 'POST',
      data: {
        idr: idr,
        pagado: pagado
      },
      success: function (data) {
        console.log(data);
        // escondemos el id servicePay por 2 segundos para simular que se esta procesando el pago
        setTimeout(function () {
          $('#paytext').show();
          fetchNextService();
        spinner.hide();
        }, 2000);
        
      }
    });
  });

  document.getElementById('nameSing').addEventListener('click', function() {
    var name = $("#nameSing").val();
    var printWindow = window.open('', '_blank');
    
    printWindow.document.write(`
        <html>
            <head>
                <title>Imprimir</title>
                <style>
                    @page { size: A4 landscape; margin: 0; }
                    body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; text-align: center; flex-direction: column; }
                    img { max-width: 80vw; max-height: 40vh; min-width: 30vw; min-height: 15vh; } /* Ajusta el tamaño del logo */
                    h1 { margin: 0; font-size: 15vw; text-transform: uppercase; flex-grow: 1; display: flex; align-items: center; justify-content: center; } /* Ajusta el tamaño del texto y lo transforma a mayúsculas */
                </style>
            </head>
            <body>
                <img src="https://deserttravelplus.com/btec_v1/assets/img/logo-color-1.png" alt="Logo">
                <h1>${name}</h1>
            </body>
        </html>
    `);
    
    printWindow.document.close();

    // Añadimos un pequeño retraso antes de cerrar para asegurarnos de que la impresión se inicia antes
    printWindow.print();
    setTimeout(() => {
        printWindow.close();
    }, 500);
});





</script>
  </body>
</html>