<?php 

session_start();

setlocale( LC_TIME, 'es_MX.UTF-8', 'esp' );

$sessData = !empty( $_SESSION[ 'sessData' ] ) ? $_SESSION[ 'sessData' ] : '';

if ( !empty( $sessData[ 'status' ][ 'msg' ] ) ) {

  $statusMsg = $sessData[ 'status' ][ 'msg' ];

  $statusMsgType = $sessData[ 'status' ][ 'type' ];

  unset( $_SESSION[ 'sessData' ][ 'status' ] );

}



if ( isset( $_SESSION[ 'sessData' ] ) && $_SESSION[ 'sessData' ] == true ) {} else {



  echo '<script type="text/javascript">window.location.href="login.php";

    </script>';

  exit;

}





if ( !empty( $sessData[ 'userLoggedIn' ] ) && !empty( $sessData[ 'userID' ] ) ) {

  include 'func/user.php';

  $user = new User();

  $conditions[ 'where' ] = array(

    'id' => $sessData[ 'userID' ],

  );

  $conditions[ 'return_type' ] = 'single';

  $userData = $user->getRows( $conditions );

  $name = $userData[ 'first_name' ];

  $userName = $userData[ 'first_name' ];

  $email = $userData[ 'email' ];

  $ida = $userData[ 'ida' ];

  $userID = $userData[ 'id' ];

  $rol = $userData[ 'rol' ];

  $avatar = $userData[ 'avatar' ];

}

include 'func/conn.php';

$sql = "SELECT * FROM generales WHERE ida = '$ida'";

$result = $conn->query( $sql );



if ( $result->num_rows > 0 ) {

  // output data of each row

  while ( $row = $result->fetch_assoc() ) {



    $empresa = $row[ "empresa" ];

    $logo = $row[ "logo" ];

    $empresa_telefono = $row[ "telefono" ];

    $empresa_email = $row[ "email" ];



  }



}

?>



<!DOCTYPE html>



<html lang="en"

  class="light-style layout-navbar-fixed layout-menu-fixed"

  dir="ltr"

  data-theme="theme-default"

  data-assets-path="assets/"

  data-template="vertical-menu-template"

>

<head>

<meta charset="utf-8" />

<meta

      name="viewport"

      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"

    />

<meta name="robots" content="noindex" />

<title>Reportes  | Btec</title>



<!-- Favicon -->

<link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />



<!-- Fonts -->

<link rel="preconnect" href="https://fonts.googleapis.com" />

<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />

<link

      href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"

      rel="stylesheet"

    />



<!-- Icons -->

<link rel="stylesheet" href="assets/vendor/fonts/boxicons.css" />

<link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />



<!-- Core CSS -->

<link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />

<link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />

<link rel="stylesheet" href="assets/css/demo.css" />

<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />


<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script> 



<!-- Vendors CSS -->

<link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

<!-- Latest compiled and minified CSS -->



<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker3.min.css" integrity="sha512-rxThY3LYIfYsVCWPCW9dB0k+e3RZB39f23ylUYTEuZMDrN/vRqLdaCBo/FbvVT6uC2r0ObfPzotsfKF9Qc5W5g==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">



<!-- Page CSS --> 



<!-- Helpers --> 

<script src="assets/vendor/js/helpers.js"></script> 



<!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section --> 

<!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  --> 

<script src="assets/vendor/js/template-customizer.js"></script> 

<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  --> 

<script src="assets/js/config.js"></script>

</head>



<body>

<!-- Layout wrapper -->

<div class="layout-wrapper layout-content-navbar">

  <div class="layout-container"> 

    <!-- Menu -->
    <?php include('layout/menu.php'); ?>
   <!-- / Menu --> 

    

    <!-- Layout container -->

    <div class="layout-page"> 

      <!-- Navbar -->

      

      <?php include('layout/navbar.php'); ?>

      

      <!-- / Navbar --> 

      

      <!-- Content wrapper -->

      <div class="content-wrapper"> 

        <!-- Content -->

        

        <div class="container-xxl flex-grow-1 container-p-y">

        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <div class="mb-3"><label for="flatpickr-range" class="form-label">FECHAS</label>
                   <input type="text" class="form-control" placeholder="YYYY-MM-DD to YYYY-MM-DD" id="flatpickr-range" />
                </div>
              </div>
              <!-- agregamos botos de busqueda -->
              <div class="form-group">
                <button type="button" class="btn btn-primary" id="buscar">Buscar</button>
              </div>
            </div>
          </div>
          <div class="row mt-5 mb-5">
          <!-- agregamos los data-range -->
          <div class="col-lg-12 col-md-12 mb-4">
                <div class="card card-datatable table-responsive pt-0">
                    <div class="card-header header-elements">
                        <div class="ps-0 ps-sm-2 d-flex flex-column mb-2 mb-sm-0">
                            <p class="card-subtitle text-muted mb-1">Servicios</p>
                            <h5 class="card-title mb-0" id="totalServicios"></h5>
                        </div>
                        <div class="card-action-element ms-auto py-0"></div>
                    </div>
                    <table class="datatables-basic table table-bordered" id="reservas-agencia">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Empresa</th>
                                <th>Total</th>
                                <th>Servicios</th>
                                <th>Relación</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Table rows go here -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 mb-4" id="widgetCuentasCobrar">
                <div class="card card-datatable table-responsive pt-0">
                    <div class="card-header header-elements">
                        <div class="ps-0 ps-sm-2 d-flex flex-column mb-2 mb-sm-0">
                            <p class="card-subtitle text-muted mb-1">Cuentas Por Cobrar</p>
                            <h5 class="card-title mb-0" id="totalGen">$0.00</h5>
                        </div>
                        <div class="card-action-element ms-auto py-0"></div>
                    </div>
                    <table class="datatables-basic table table-bordered" id="pagos-pendientes">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Empresa</th>
                                <th>Total</th>
                                <th>Relación</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Table rows go here -->
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- / chart cuentas por cobrar -->
            <div class="col-lg-6 col-md-6 mb-4" id="cuentasCobrarChartContainer">
                <div class="card mb-5">
                    <div class="card-header header-elements">
                        <div class="ps-0 ps-sm-2 d-flex flex-column mb-2 mb-sm-0">
                            <p class="card-subtitle text-muted mb-1">Balance</p>
                            <h5 class="card-title mb-0" id="balance-semanal">$0.00</h5>
                        </div>
                        <div class="card-action-element ms-auto py-0"></div>
                    </div>
                    <div class="card-body">
                        <canvas id="cuentasCobrarChart" class="chartjs" style="min-height: 420px;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- Modal -->
<div class="modal fade" id="getRelacion" tabindex="-1" aria-labelledby="getRelacionLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="getRelacionLabel">Relacion de Servicios</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <h4 class="modal-subtitle text-primary" id="proveedor"></h4>
        <div class="table-responsive">
        <table class="table table-bordered" id="relacion-servicios">
          <thead>
            <tr>
              <th>#</th>
              <th>Fecha</th>
              <th>Servicio</th>
              <th>Origen</th>
              <th>Destino</th>
              <th>Cliente</th>
              <th>Pax</th>
              <th>Vuelo</th>
              <th>Pick up</th>
              <th>ID Servicio</th>
              <th>Chofer</th>
              <th>Unidad</th>
              <th>Agencia</th>
              <th>Observaciones</th>
              <th>Monto</th>
              <th>Acciones</th>
            </tr>
          </thead>
          <tbody>
            <!-- Los datos serán cargados dinámicamente -->
          </tbody>
        </table>
        </div>
      </div>
      <div class="modal-footer">
    <button type="button" class="btn btn-primary" id="exportExcel">Exportar a Excel</button>
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
</div>

    </div>
  </div>
</div>


        <!-- / Content --> 

        

        <!-- Footer -->

        <footer class="content-footer footer bg-footer-theme">

          <div class="container-fluid d-flex flex-column flex-md-row flex-wrap justify-content-between py-2">

            <div class="mb-2 mb-md-0"> Made with ❤️ by <a href="#" class="footer-link fw-semibold">CodeMaster.MX</a></div>

          </div>

        </footer>

        <!-- / Footer -->

        

        <div class="content-backdrop fade"></div>

      </div>

      <!-- Content wrapper --> 

    </div>

    <!-- / Layout page --> 

  </div>

  

  <!-- Overlay -->

  <div class="layout-overlay layout-menu-toggle"></div>

  

  <!-- Drag Target Area To SlideIn Menu On Small Screens -->

  <div class="drag-target"></div>

</div>





<!-- / Layout wrapper --> 



<!-- Core JS --> 

<!-- build:js assets/vendor/js/core.js --> 



<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script> 
<script src="assets/vendor/libs/hammer/hammer.js"></script> 
<script src="assets/vendor/libs/i18n/i18n.js"></script> 
<script src="assets/vendor/libs/typeahead-js/typeahead.js"></script> 
<script src="assets/vendor/js/menu.js"></script> 
<script src="assets/vendor/libs/chartjs/chartjs.js"></script>
<script src="https://kit.fontawesome.com/651e797dfa.js" crossorigin="anonymous"></script> 
<!-- Main JS --> 

<script src="assets/js/main.js"></script> 
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
$(document).ready(function () {
  var flatpickrRange = document.querySelector("#flatpickr-range");

flatpickrRange.flatpickr({
  mode: "range"
});
    let cardColor, headingColor, labelColor, borderColor, legendColor;

    if (isDarkStyle) {
        cardColor = config.colors_dark.cardColor;
        headingColor = config.colors_dark.headingColor;
        labelColor = config.colors_dark.textMuted;
        legendColor = config.colors_dark.bodyColor;
        borderColor = config.colors_dark.borderColor;
    } else {
        cardColor = config.colors.cardColor;
        headingColor = config.colors.headingColor;
        labelColor = config.colors.textMuted;
        legendColor = config.colors.bodyColor;
        borderColor = config.colors.borderColor;
    }

   
const cuentasCobrarChart = document.getElementById('cuentasCobrarChart');

let cuentasCobrarChartVar; // Define la variable globalmente para que se pueda acceder y destruir el gráfico existente

function actualizarGraficaCobrar() { 
    $.ajax({
        url: 'func/reportes-cuentas-todo.php',
        type: 'POST',
        success: function(data) {
            console.log("Respuesta de cuentas por pagar:", data);
            try {
                var cuentasPagar = typeof data === 'string' ? JSON.parse(data) : data;
                var labelsPagar = cuentasPagar.map(item => item.empresa);
                var dataPagar = cuentasPagar.map(item => item.total_pagar);

                var colors = ['rgba(255, 99, 132, 0.8)', 'rgba(54, 162, 235, 0.8)', 'rgba(255, 206, 86, 0.8)', 'rgba(75, 192, 192, 0.8)'];

                if (cuentasCobrarChartVar) {
                    cuentasCobrarChartVar.destroy(); // Destruye el gráfico existente antes de crear uno nuevo
                }

                cuentasCobrarChartVar = new Chart(cuentasCobrarChart, {
                    type: 'bar',
                    data: {
                        labels: labelsPagar,
                        datasets: [{
                            label: 'Cuentas por Pagar',
                            data: dataPagar,
                            backgroundColor: cuentasPagar.map((item, index) => colors[index % colors.length]),
                            borderColor: 'transparent',
                            maxBarThickness: 40
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        animation: { duration: 500 },
                        plugins: {
                            tooltip: {
                                rtl: isRtl,
                                backgroundColor: cardColor,
                                titleColor: 'rgba(255, 255, 255, 1)',
                                bodyColor: legendColor,
                                borderWidth: 1,
                                borderColor: borderColor
                            },
                            legend: { display: false }
                        },
                        scales: {
                            x: {
                                min: 0,
                                grid: { color: borderColor, borderColor: borderColor },
                                ticks: { color: labelColor }
                            },
                            y: {
                                grid: { borderColor: borderColor, display: false, drawBorder: false },
                                ticks: { color: labelColor }
                            }
                        }
                    }
                });

                cuentasCobrarChartVar.update();
                document.getElementById("cuentasCobrarChartContainer").classList.add("d-none");
            } catch (e) {
                console.error("Error parsing JSON:", e);
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.error("Error en la solicitud AJAX de cuentas por pagar:", textStatus, errorThrown);
            console.error("Detalles del error:", jqXHR.responseText);
        }
    });
    
}

actualizarGraficaCobrar();

var tableCuentasCobrar = $('#pagos-pendientes').DataTable({
  ajax: {
    url: 'func/reportes-cuentas-todo.php',
    dataSrc: ''
  },
  columns: [
    { 
      data: null,
      render: function (data, type, row, meta) {
        return meta.row + meta.settings._iDisplayStart + 1;
      }
    },
    { data: 'empresa' },
    { data: 'total_pagar' },
    { data: 'proveedor_id' }
  ],
  columnDefs: [
    {
      // For Responsive
      className: 'control',
      orderable: false,
      responsivePriority: 2,
      searchable: false,
      targets: 0
    },
    {
      targets: 1,
      searchable: true,
    },
    {
      targets: 2,
      searchable: true,
    },
    {
      targets: 3,
      searchable: true,
      render: function(data, type, row) {
        return '<i data-bs-toggle="modal" data-bs-target="#getRelacion" data-empresa="' + row.proveedor_id + '" class="fa-solid fa-list text-primary"></i>';
      }
    },
  ],
  order: [[0, 'asc']]
});

tableCuentasCobrar.on('draw', function() {
  var total = tableCuentasCobrar.column(2).data().reduce(function (a, b) {
    return parseFloat(a) + parseFloat(b);
  }, 0);
  console.log(total);
  $('#totalGen').text('$' + total.toFixed(2));
  document.getElementById("widgetCuentasCobrar").classList.add("d-none");
});
$('[data-bs-target="#getRelacion"]').off('click');

$(document).on('click', '[data-bs-target="#getRelacion"]', function() {
    var empresa = $(this).data('empresa');
    console.log("Empresa seleccionada:", empresa);
    var flatpickrRange = document.getElementById("flatpickr-range").value;
    var startDate = null;
    var endDate = null;

    // Validar si flatpickrRange tiene un valor
    if (flatpickrRange) {
        var dates = flatpickrRange.split(" to ");
        startDate = dates[0];
        endDate = dates[1];
    }

    // Preparar los datos para enviar
    var requestData = { empresa: empresa };
    if (startDate && endDate) {
        requestData.start_date = startDate;
        requestData.end_date = endDate;
    }

    $.ajax({
        url: 'func/get-relacion-servicios.php',
        method: 'POST',
        data: requestData,
        dataType: 'json',
        success: function(response) {
            var tbody = $('#relacion-servicios tbody');
            tbody.empty();
        //pasamos el nombre de la empresa al modal
        $('#proveedor').text(empresa);

            if (response.length > 0) {
                response.forEach(function(row, index) {
                    // Si el chofer es null, undefined o una cadena vacía, asignar "Sin Asignar"
                    var chofer = (row.chofer === null || row.chofer === undefined || row.chofer === '') ? 'Sin Asignar' : row.chofer;
                    // Si el proveedor es null, undefined o una cadena vacía, asignar "Sin Asignar"
                    var proveedor = (row.proveedor === null || row.proveedor === undefined || row.proveedor === '') ? 'Sin Asignar' : row.proveedor;
                    
                    var buttonClass = row.estado === 'pendiente' ? 'btn-success' : 'btn-warning';
                    var buttonText = row.estado === 'pendiente' ? 'Marcar como PAGADA' : 'Marcar como NO PAGADA';
                    var folio = row.folio === null ? 'Sin Folio' : row.folio;
                    var obs = row.obs === null ? '' : row.obs;
                    var obs_int = row.obs_int === null ? '' : row.obs_int;
                    var chofer = row.chofer === null ? 'Sin Asignar' : row.chofer;
                    tbody.append(
                        '<tr>' +
                        '<td>' + (index + 1) + '</td>' +
                        '<td>' + (row.fecha_servicio) + '</td>' +
                        '<td>' + row.servicio + '</td>' +
                        '<td>' + row.pickup + '</td>' + // Columna de proveedor con valor modificado si es null
                        '<td>' + row.destino + '</td>' + // Columna de chofer con valor modificado si es null
                        '<td>' + row.cliente + '</td>' +
                        '<td>' + row.pax + '</td>' +
                        '<td>' + row.airline + '</td>' +
                        '<td>' + row.hora + '</td>' +
                        '<td>' + row.folio + '</td>' +
                        '<td>' + chofer + '</td>' +
                        '<td>' + row.car + '</td>' +
                        '<td>' + row.agencia + '</td>' +
                        '<td>' + obs + ' ' + obs_int + '</td>' +
                        '<td>' + (row.monto) + '</td>' +
                        '<td>' +
                        'N/A' +
                        //'<button class="btn btn-sm ' + buttonClass + ' markPay" data-id="' + row.id + '" data-status="'+ buttonText +'">' + buttonText + '</button>' +
                        '</td>' +
                        '</tr>'
                    );
                });
            } else {
                tbody.append('<tr><td colspan="8" class="text-center">No se encontraron registros</td></tr>');
            }
        },
        error: function(xhr, status, error) {
          console.error('Error al obtener los datos:', xhr.responseText);
          //lo mostramos en un alert
          Swal.fire({
            icon: 'error',
            title: 'Error al obtener los datos',
            text: 'Ha ocurrido un error al intentar obtener los datos de la relación de servicios - '.xhr.responseText
          });
        }
    });
});



$(document).on('click', '.markPay', function() {
  var id = $(this).data('id');
  var status = $(this).data('status');
  
  // Realiza la actualización en la base de datos mediante AJAX
  $.ajax({
    url: 'func/actualizar-relacion.php',
    method: 'POST',
    data: { id: id, status: status},
    dataType: 'json',
    success: function(response) {
      //cerramos el modal getRelacion
      $('#getRelacion').modal('hide');
      $('.modal-backdrop').remove();
      $('body').removeClass('modal-open');

      if (response.respuesta === 'correcto') {

          // Actualiza la tabla de cuentas por pagar
          tableCuentasCobrar.ajax.reload();
          // Actualiza el gráfico de cuentas por pagar
           actualizarGraficaCobrar();
        
      } else {
        
        Swal.fire({
          icon: 'error',
          title: 'Error al completar el servicio',
          text: 'Ha ocurrido un error al intentar marcar el servicio como pagado'
        });
      }
    },
    error: function(xhr, status, error) {
      console.error('Error al completar el servicio:', error);
    }
  });
});

$('#getRelacion').on('show.bs.modal', function (e) {
  // agregar el "backdrop"
  $('body').addClass('modal-open');

  // Muestra el loader
  $('.modal-loader').show();
});

  });


document.getElementById("buscar").addEventListener("click", function () {
    var flatpickrRange = document.getElementById("flatpickr-range").value;
    
    // Si no hay un rango de fechas, no hacer nada
    if (!flatpickrRange) {
        alert("Por favor, seleccione un rango de fechas.");
        return;
    }

    // Dividir las fechas en inicio y fin
    var dates = flatpickrRange.split(" to ");
    var startDate = dates[0];
    var endDate = dates[1];

    // Crear un objeto con las fechas para enviar al backend
    var requestData = {
        start_date: startDate,
        end_date: endDate
    };

    // Realizar una solicitud AJAX para enviar los datos al backend
    fetch("func/get-rage-reservas.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(requestData)
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            console.error("Error: ", data.error);
        } else {
            console.log("Datos recibidos: ", data);

            if (data.reservas && data.reservas.length > 0) {
                // Escondemos widgetCuentasCobrar aplicándole la clase d-none
                

                // Actualizar la tabla de reservas
                var tableReservas = $('#reservas-agencia').DataTable();
                tableReservas.clear().rows.add(data.reservas).draw();

                // Actualizar la gráfica con los datos recibidos
                
            } else {
                console.warn("No se encontraron reservas en el rango de fechas especificado.");
            }
        }
    })
    .catch(error => console.error("Error en la solicitud: ", error));
});




// Inicializar la tabla 'reservas-agencia' usando DataTables
$(document).ready(function() {
    $('#reservas-agencia').DataTable({
        columns: [
            { 
                data: null,
                render: function (data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'agencia' }, // Muestra la agencia agrupada
            { 
                data: 'total_suma', 
                render: function(data, type, row) {
                    return '$' + parseFloat(data).toFixed(2);
                } 
            }, // Muestra el total por agencia
            { data: 'num_registros' }, // Muestra el número de registros por agencia
            { 
                data: null,
                render: function(data, type, row) {
                    return '<i data-bs-toggle="modal" data-bs-target="#getRelacion" data-empresa="' + row.agencia + '" class="fa-solid fa-list text-primary"></i>';
                }
            }

        ],
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets: 0
            },
        ],
        order: [[2, 'desc']] // Ordenar por total en orden descendente
    });
    
});



$(document).on('click', '#exportExcel', function() {
    var table = document.getElementById('relacion-servicios');
    var clonedTable = table.cloneNode(true);
    var rows = clonedTable.querySelectorAll('tr');

    // Crear una matriz donde cada fila es un array de celdas, esto permite controlar cada celda individualmente
    var data = [];

    // Recorre cada fila y añade a la matriz `data`
    rows.forEach(function(row, index) {
        var rowData = [];
        row.querySelectorAll('td, th').forEach(function(cell, cellIndex) {
            var cellText = cell.textContent.trim();

            // Si es la columna de fecha (por ejemplo, segunda columna), la formateamos como texto
            if (cellIndex === 1 && index > 0) { // Suponiendo que la fecha está en la segunda columna y no es el encabezado
                var formattedDate = new Date(cellText);
                cellText = formattedDate.toISOString().split('T')[0]; // YYYY-MM-DD
                cellText = `${cellText}`; // Agregar una comilla simple para que Excel lo vea como texto
            }

            rowData.push(cellText);
        });
        data.push(rowData);
    });

    // Convertir la matriz `data` en una hoja de Excel con SheetJS
    var worksheet = XLSX.utils.aoa_to_sheet(data);
    var workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

    // Exportar el libro a un archivo Excel
    XLSX.writeFile(workbook, 'Relacion_de_Servicios.xlsx');
});







</script>
    </body>
    </html>
